//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;

namespace MatrixMultiplication
{
	/// <summary>
	/// Podsumowanie dla MatrixMultiplyDirect.
	/// </summary>
	public class MatrixMultiplyDirect : MatrixMultiply
	{
		public MatrixMultiplyDirect(double [,] A, double [,] B) : base(A,B)
		{
		}
		public override double [,] Multiply()
		{
			for(int i = 0; i < A.GetLength(0); i++)
				for(int j = 0; j < B.GetLength(1); j++)
					C[i,j] = 0.0;

			// Ptla dla wierszy A
			for(int i = 0; i < A.GetLength(0); i++)
				// Ptla dla kolumn A i wierszy B
				for(int j = 0; j < A.GetLength(1); j++)
				{
					// Ptla dla kolumn B
					for(int k = 0; k < B.GetLength(1); k++)
						C[i,k] += A[i,j] * B[j,k];
				}
			return C;
		}
	}
}
